/*! lg-thumbnail - v1.1.0 - 2017-08-08
* http://sachinchoolur.github.io/lightGallery
* Copyright (c) 2017 Sachin N; Licensed GPLv3 */

(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module unless amdModuleId is set
        define(['jquery'], function (a0) {
            return (factory(a0));
        });
    } else if (typeof exports === 'object') {
        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like environments that support module.exports,
        // like Node.
        module.exports = factory(require('jquery'));
    } else {
        factory(jQuery);
    }
}(this, function ($) {

    (function () {

        'use strict';

        var defaults = {
            thumbnail: true,

            animateThumb: true,
            currentPagerPosition: 'middle',

            thumbWidth: 100,
            thumbHeight: '80px',
            thumbContHeight: 100,
            thumbMargin: 5,

            exThumbImage: false,
            showThumbByDefault: true,
            toogleThumb: true,
            pullCaptionUp: true,

            enableThumbDrag: true,
            enableThumbSwipe: true,
            swipeThreshold: 50,

            loadYoutubeThumbnail: true,
            youtubeThumbSize: 1,

            loadVimeoThumbnail: true,
            vimeoThumbSize: 'thumbnail_small',

            loadDailymotionThumbnail: true
        };

        var Thumbnail = function (element) {

            // get lightGallery core plugin data
            this.core = $(element).data('lightGallery');

            // extend module default settings with lightGallery core settings
            this.core.s = $.extend({}, defaults, this.core.s);

            this.$el = $(element);
            this.$thumbOuter = null;
            this.thumbOuterWidth = 0;
            this.thumbTotalWidth = (this.core.$items.length * (this.core.s.thumbWidth + this.core.s.thumbMargin));
            this.thumbIndex = this.core.index;

            if (this.core.s.animateThumb) {
                this.core.s.thumbHeight = '100%';
            }

            // Thumbnail animation value
            this.left = 0;

            this.init();

            return this;
        };

        Thumbnail.prototype.init = function () {
            var _this = this;
            if (this.core.s.thumbnail && this.core.$items.length > 1) {
                if (this.core.s.showThumbByDefault) {
                    setTimeout(function () {
                        _this.core.$outer.addClass('lg-thumb-open');
                    }, 700);
                }

                if (this.core.s.pullCaptionUp) {
                    this.core.$outer.addClass('lg-pull-caption-up');
                }

                this.build();
                if (this.core.s.animateThumb && this.core.doCss()) {
                    if (this.core.s.enableThumbDrag) {
                        this.enableThumbDrag();
                    }

                    if (this.core.s.enableThumbSwipe) {
                        this.enableThumbSwipe();
                    }

                    this.thumbClickable = false;
                } else {
                    this.thumbClickable = true;
                }

                this.toogle();
                this.thumbkeyPress();
            }
        };

        Thumbnail.prototype.build = function () {
            var _this = this;
            var thumbList = '';
            var vimeoErrorThumbSize = '';
            var $thumb;
            var html = '<div class="lg-thumb-outer">' +
                '<div class="lg-thumb lg-group">' +
                '</div>' +
                '</div>';

            switch (this.core.s.vimeoThumbSize) {
                case 'thumbnail_large':
                    vimeoErrorThumbSize = '640';
                    break;
                case 'thumbnail_medium':
                    vimeoErrorThumbSize = '200x150';
                    break;
                case 'thumbnail_small':
                    vimeoErrorThumbSize = '100x75';
            }

            _this.core.$outer.addClass('lg-has-thumb');

            _this.core.$outer.find('.lg').append(html);

            _this.$thumbOuter = _this.core.$outer.find('.lg-thumb-outer');
            _this.thumbOuterWidth = _this.$thumbOuter.width();

            if (_this.core.s.animateThumb) {
                _this.core.$outer.find('.lg-thumb').css({
                    width: _this.thumbTotalWidth + 'px',
                    position: 'relative'
                });
            }

            if (this.core.s.animateThumb) {
                _this.$thumbOuter.css('height', _this.core.s.thumbContHeight + 'px');
            }

            function getThumb(src, thumb, index) {
                var isVideo = _this.core.isVideo(src, index) || {};
                var thumbImg;
                var vimeoId = '';

                if (isVideo.youtube || isVideo.vimeo || isVideo.dailymotion) {
                    if (isVideo.youtube) {
                        if (_this.core.s.loadYoutubeThumbnail) {
                            thumbImg = '//img.youtube.com/vi/' + isVideo.youtube[1] + '/' + _this.core.s.youtubeThumbSize + '.jpg';
                        } else {
                            thumbImg = thumb;
                        }
                    } else if (isVideo.vimeo) {
                        if (_this.core.s.loadVimeoThumbnail) {
                            thumbImg = '//i.vimeocdn.com/video/error_' + vimeoErrorThumbSize + '.jpg';
                            vimeoId = isVideo.vimeo[1];
                        } else {
                            thumbImg = thumb;
                        }
                    } else if (isVideo.dailymotion) {
                        if (_this.core.s.loadDailymotionThumbnail) {
                            thumbImg = '//www.dailymotion.com/thumbnail/video/' + isVideo.dailymotion[1];
                        } else {
                            thumbImg = thumb;
                        }
                    }
                } else {
                    thumbImg = thumb;
                }

                thumbList += '<div data-vimeo-id="' + vimeoId + '" class="lg-thumb-item" style="width:' + _this.core.s.thumbWidth + 'px; height: ' + _this.core.s.thumbHeight + '; margin-right: ' + _this.core.s.thumbMargin + 'px"><img src="' + thumbImg + '" /></div>';
                vimeoId = '';
            }

            if (_this.core.s.dynamic) {
                for (var i = 0; i < _this.core.s.dynamicEl.length; i++) {
                    getThumb(_this.core.s.dynamicEl[i].src, _this.core.s.dynamicEl[i].thumb, i);
                }
            } else {
                _this.core.$items.each(function (i) {

                    if (!_this.core.s.exThumbImage) {
                        getThumb($(this).attr('href') || $(this).attr('data-src'), $(this).find('img').attr('src'), i);
                    } else {
                        getThumb($(this).attr('href') || $(this).attr('data-src'), $(this).attr(_this.core.s.exThumbImage), i);
                    }

                });
            }

            _this.core.$outer.find('.lg-thumb').html(thumbList);

            $thumb = _this.core.$outer.find('.lg-thumb-item');

            // Load vimeo thumbnails
            $thumb.each(function () {
                var $this = $(this);
                var vimeoVideoId = $this.attr('data-vimeo-id');

                if (vimeoVideoId) {
                    $.getJSON('//www.vimeo.com/api/v2/video/' + vimeoVideoId + '.json?callback=?', {
                        format: 'json'
                    }, function (data) {
                        $this.find('img').attr('src', data[0][_this.core.s.vimeoThumbSize]);
                    });
                }
            });

            // manage active class for thumbnail
            $thumb.eq(_this.core.index).addClass('active');
            _this.core.$el.on('onBeforeSlide.lg.tm', function () {
                $thumb.removeClass('active');
                $thumb.eq(_this.core.index).addClass('active');
            });

            $thumb.on('click.lg touchend.lg', function () {
                var _$this = $(this);
                setTimeout(function () {

                    // In IE9 and bellow touch does not support
                    // Go to slide if browser does not support css transitions
                    if ((_this.thumbClickable && !_this.core.lgBusy) || !_this.core.doCss()) {
                        _this.core.index = _$this.index();
                        _this.core.slide(_this.core.index, false, true, false);
                    }
                }, 50);
            });

            _this.core.$el.on('onBeforeSlide.lg.tm', function () {
                _this.animateThumb(_this.core.index);
            });

            $(window).on('resize.lg.thumb orientationchange.lg.thumb', function () {
                setTimeout(function () {
                    _this.animateThumb(_this.core.index);
                    _this.thumbOuterWidth = _this.$thumbOuter.width();
                }, 200);
            });

        };

        Thumbnail.prototype.setTranslate = function (value) {
            // jQuery supports Automatic CSS prefixing since jQuery 1.8.0
            this.core.$outer.find('.lg-thumb').css({
                transform: 'translate3d(-' + (value) + 'px, 0px, 0px)'
            });
        };

        Thumbnail.prototype.animateThumb = function (index) {
            var $thumb = this.core.$outer.find('.lg-thumb');
            if (this.core.s.animateThumb) {
                var position;
                switch (this.core.s.currentPagerPosition) {
                    case 'left':
                        position = 0;
                        break;
                    case 'middle':
                        position = (this.thumbOuterWidth / 2) - (this.core.s.thumbWidth / 2);
                        break;
                    case 'right':
                        position = this.thumbOuterWidth - this.core.s.thumbWidth;
                }
                this.left = ((this.core.s.thumbWidth + this.core.s.thumbMargin) * index - 1) - position;
                if (this.left > (this.thumbTotalWidth - this.thumbOuterWidth)) {
                    this.left = this.thumbTotalWidth - this.thumbOuterWidth;
                }

                if (this.left < 0) {
                    this.left = 0;
                }

                if (this.core.lGalleryOn) {
                    if (!$thumb.hasClass('on')) {
                        this.core.$outer.find('.lg-thumb').css('transition-duration', this.core.s.speed + 'ms');
                    }

                    if (!this.core.doCss()) {
                        $thumb.animate({
                            left: -this.left + 'px'
                        }, this.core.s.speed);
                    }
                } else {
                    if (!this.core.doCss()) {
                        $thumb.css('left', -this.left + 'px');
                    }
                }

                this.setTranslate(this.left);

            }
        };

        // Enable thumbnail dragging and swiping
        Thumbnail.prototype.enableThumbDrag = function () {

            var _this = this;
            var startCoords = 0;
            var endCoords = 0;
            var isDraging = false;
            var isMoved = false;
            var tempLeft = 0;

            _this.$thumbOuter.addClass('lg-grab');

            _this.core.$outer.find('.lg-thumb').on('mousedown.lg.thumb', function (e) {
                if (_this.thumbTotalWidth > _this.thumbOuterWidth) {
                    // execute only on .lg-object
                    e.preventDefault();
                    startCoords = e.pageX;
                    isDraging = true;

                    // ** Fix for webkit cursor issue https://code.google.com/p/chromium/issues/detail?id=26723
                    _this.core.$outer.scrollLeft += 1;
                    _this.core.$outer.scrollLeft -= 1;

                    // *
                    _this.thumbClickable = false;
                    _this.$thumbOuter.removeClass('lg-grab').addClass('lg-grabbing');
                }
            });

            $(window).on('mousemove.lg.thumb', function (e) {
                if (isDraging) {
                    tempLeft = _this.left;
                    isMoved = true;
                    endCoords = e.pageX;

                    _this.$thumbOuter.addClass('lg-dragging');

                    tempLeft = tempLeft - (endCoords - startCoords);

                    if (tempLeft > (_this.thumbTotalWidth - _this.thumbOuterWidth)) {
                        tempLeft = _this.thumbTotalWidth - _this.thumbOuterWidth;
                    }

                    if (tempLeft < 0) {
                        tempLeft = 0;
                    }

                    // move current slide
                    _this.setTranslate(tempLeft);

                }
            });

            $(window).on('mouseup.lg.thumb', function () {
                if (isMoved) {
                    isMoved = false;
                    _this.$thumbOuter.removeClass('lg-dragging');

                    _this.left = tempLeft;

                    if (Math.abs(endCoords - startCoords) < _this.core.s.swipeThreshold) {
                        _this.thumbClickable = true;
                    }

                } else {
                    _this.thumbClickable = true;
                }

                if (isDraging) {
                    isDraging = false;
                    _this.$thumbOuter.removeClass('lg-grabbing').addClass('lg-grab');
                }
            });

        };

        Thumbnail.prototype.enableThumbSwipe = function () {
            var _this = this;
            var startCoords = 0;
            var endCoords = 0;
            var isMoved = false;
            var tempLeft = 0;

            _this.core.$outer.find('.lg-thumb').on('touchstart.lg', function (e) {
                if (_this.thumbTotalWidth > _this.thumbOuterWidth) {
                    e.preventDefault();
                    startCoords = e.originalEvent.targetTouches[0].pageX;
                    _this.thumbClickable = false;
                }
            });

            _this.core.$outer.find('.lg-thumb').on('touchmove.lg', function (e) {
                if (_this.thumbTotalWidth > _this.thumbOuterWidth) {
                    e.preventDefault();
                    endCoords = e.originalEvent.targetTouches[0].pageX;
                    isMoved = true;

                    _this.$thumbOuter.addClass('lg-dragging');

                    tempLeft = _this.left;

                    tempLeft = tempLeft - (endCoords - startCoords);

                    if (tempLeft > (_this.thumbTotalWidth - _this.thumbOuterWidth)) {
                        tempLeft = _this.thumbTotalWidth - _this.thumbOuterWidth;
                    }

                    if (tempLeft < 0) {
                        tempLeft = 0;
                    }

                    // move current slide
                    _this.setTranslate(tempLeft);

                }
            });

            _this.core.$outer.find('.lg-thumb').on('touchend.lg', function () {
                if (_this.thumbTotalWidth > _this.thumbOuterWidth) {

                    if (isMoved) {
                        isMoved = false;
                        _this.$thumbOuter.removeClass('lg-dragging');
                        if (Math.abs(endCoords - startCoords) < _this.core.s.swipeThreshold) {
                            _this.thumbClickable = true;
                        }

                        _this.left = tempLeft;
                    } else {
                        _this.thumbClickable = true;
                    }
                } else {
                    _this.thumbClickable = true;
                }
            });

        };

        Thumbnail.prototype.toogle = function () {
            var _this = this;
            if (_this.core.s.toogleThumb) {
                _this.core.$outer.addClass('lg-can-toggle');
                _this.$thumbOuter.append('<span class="lg-toogle-thumb lg-icon"></span>');
                _this.core.$outer.find('.lg-toogle-thumb').on('click.lg', function () {
                    _this.core.$outer.toggleClass('lg-thumb-open');
                });
            }
        };

        Thumbnail.prototype.thumbkeyPress = function () {
            var _this = this;
            $(window).on('keydown.lg.thumb', function (e) {
                if (e.keyCode === 38) {
                    e.preventDefault();
                    _this.core.$outer.addClass('lg-thumb-open');
                } else if (e.keyCode === 40) {
                    e.preventDefault();
                    _this.core.$outer.removeClass('lg-thumb-open');
                }
            });
        };

        Thumbnail.prototype.destroy = function () {
            if (this.core.s.thumbnail && this.core.$items.length > 1) {
                $(window).off('resize.lg.thumb orientationchange.lg.thumb keydown.lg.thumb');
                this.$thumbOuter.remove();
                this.core.$outer.removeClass('lg-has-thumb');
            }
        };

        $.fn.lightGallery.modules.Thumbnail = Thumbnail;

    })();

}));
